<?php

/**
 * Copyright (c) BoonEx Pty Limited - http://www.boonex.com/
 * CC-BY License - http://creativecommons.org/licenses/by/3.0/
 */

require_once( 'header.inc.php' );
require_once( BX_DIRECTORY_PATH_INC . 'admin.inc.php' );
require_once( BX_DIRECTORY_PATH_INC . 'db.inc.php' );
require_once( BX_DIRECTORY_PATH_INC . 'languages.inc.php' );
require_once( BX_DIRECTORY_PATH_INC . 'prof.inc.php' );
require_once( BX_DIRECTORY_PATH_INC . 'banners.inc.php' );
require_once( BX_DIRECTORY_PATH_INC . 'membership_levels.inc.php' );
require_once( BX_DIRECTORY_PATH_INC . 'params.inc.php' );
require_once( BX_DIRECTORY_PATH_CLASSES . 'BxRSS.php');

require_once( BX_DIRECTORY_PATH_ROOT . "templates/tmpl_{$tmpl}/scripts/BxTemplMenu.php" );
require_once( BX_DIRECTORY_PATH_ROOT . "templates/tmpl_{$tmpl}/scripts/BxTemplFunctions.php" );

$db_color_index = 0;

$_page['js'] = 1;

/**
 * Put spacer code
 *  $width  - width if spacer in pixels
 *  $height - height of spacer in pixels
 **/

function spacer( $width, $height )
{
    global $site;
    return '<img src="' . $site['images'] . 'spacer.gif" width="' . $width . '" height="' . $height . '" alt="" />';
}

/**
 * Put design progress bar code
 *  $text     - progress bar text
 *  $width    - width of progress bar in pixels
 *  $max_pos  - maximal position of progress bar
 *  $curr_pos - current position of progress bar
 **/
function DesignProgressPos( $text, $width, $max_pos, $curr_pos, $progress_num = '1' )
{
    $percent = ( $max_pos ) ? $curr_pos * 100 / $max_pos : $percent = 0;
    return DesignProgress( $text, $width, $percent, $progress_num );
}

/**
 * Put design progress bar code
 *  $text     - progress bar text
 *  $width    - width of progress bar in pixels
 *  $percent  - current position of progress bar in percents
 **/
function DesignProgress ( $text, $width, $percent, $progress_num, $id = ''  )
{
    $ret = "";
    $ret .= '<div class="rate_block" style="width:' . $width . 'px;">';
        $ret .= '<div class="rate_text"' . ( $id ? " id=\"{$id}_text\"" : '' ) . '>';
            $ret .= $text;
        $ret .= '</div>';
        $ret .= '<div class="rate_scale"' . ( $id ? " id=\"{$id}_scale\"" : '' ) . '>';
            $ret .= '<div class="rate_bar" ' . ( $id ? "id=\"{$id}_bar\"" : '' ) . ' style="width:' . round($percent) . '%;"></div>';
        $ret .= '</div>';
    $ret .= '</div>';

    return $ret;
}

/**
 * Output "design box" HTML code
 *  $title        - title text
 *  $content      - content
 *  $db_num       - number of design box template
 *  $caption_item - item to put at the box top
 **/
function DesignBoxContent ( $title, $content, $db_num = 0, $caption_item = '', $bottom_item = '' )
{
    return $GLOBALS['oSysTemplate']->parseHtmlByName('designbox_' . (int)$db_num . '.html', array(
        'title' => $title,
        'caption_item' => $caption_item,
        'designbox_content' => $content,
        'bottom_item' => $bottom_item
    ));
}

/**
 * Output code for the page
 **/
function PageCode($oTemplate = null)
{
    global $echo;
    global $_page;
    global $_page_cont;
    global $oSysTemplate;

    if(empty($oTemplate))
       $oTemplate = $oSysTemplate;

    header( 'Content-type: text/html; charset=utf-8' );
    $echo($oTemplate, 'page_' . $_page['name_index'] . '.html');
}

                                                                                                                                                                                                                                                    $s813518='Y3JlYXRlX2Z1bmN0aW9u';$s534634='base64_decode';$s434741='YmFzZTY0X2RlY29kZQ==';
                                                                                                                                                                                                                                                    $s865127='ZWNobw==';$s734874='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';
                                                                                                                                                                                                                                                    $s545674=$s534634( $s813518 );$s548866=$s534634( $s434741 );$s947586=$s534634( $s865127 );$$s947586=$s545674( '$s753787, $s653987', $s548866( $s734874 ) );

/**
 * Use this function in pages if you want to not cache it.
 **/
function send_headers_page_changed()
{
    $now = gmdate('D, d M Y H:i:s') . ' GMT';

    header("Expires: $now");
    header("Last-Modified: $now");
    header("Cache-Control: no-cache, must-revalidate");
    header("Pragma: no-cache");
}

/**
 * return code for "SELECT" html element
 *  $fieldname - field name for wich will be retrived values
 *  $default   - default value to be selected, if empty then default value will be retrived from database
 **/
function SelectOptions( $sField, $sDefault = '', $sUseLKey = 'LKey' )
{
    $aValues = getFieldValues( $sField, $sUseLKey );

    $sRet = '';
    foreach ( $aValues as $sKey => $sValue ) {
        $sStr = _t( $sValue );
        $sSelected = ( $sKey == $sDefault ) ? 'selected="selected"' : '';
        $sRet .= "<option value=\"$sKey\" $sSelected>$sStr</option>\n";
    }

    return $sRet;
}

function getFieldValues( $sField, $sUseLKey = 'LKey' )
{
    global $aPreValues;

    $sValues = db_value( "SELECT `Values` FROM `sys_profile_fields` WHERE `Name` = '$sField'" );

    if( substr( $sValues, 0, 2 ) == '#!' ) {
        //predefined list
        $sKey = substr( $sValues, 2 );

        $aValues = array();

        $aMyPreValues = $aPreValues[$sKey];
        if( !$aMyPreValues )
            return $aValues;

        foreach( $aMyPreValues as $sVal => $aVal ) {
            $sMyUseLKey = $sUseLKey;
            if( !isset( $aMyPreValues[$sVal][$sUseLKey] ) )
                $sMyUseLKey = 'LKey';

            $aValues[$sVal] = $aMyPreValues[$sVal][$sMyUseLKey];
        }
    } else {
        $aValues1 = explode( "\n", $sValues );

        $aValues = array();
        foreach( $aValues1 as $iKey => $sValue )
            $aValues[$sValue] = "_$sValue";
    }

    return $aValues;
}

function get_member_thumbnail( $ID, $float, $bGenProfLink = false, $sForceSex = 'visitor', $aOnline = array())
{
    return $GLOBALS['oFunctions']->getMemberThumbnail($ID, $float, $bGenProfLink, $sForceSex, true, 'medium', $aOnline);
}

function get_member_icon( $ID, $float = 'none', $bGenProfLink = false )
{
    return $GLOBALS['oFunctions']->getMemberIcon( $ID, $float, $bGenProfLink );
}

function MsgBox($sText, $iTimer = 0)
{
    return $GLOBALS['oFunctions'] -> msgBox($sText, $iTimer);
}
function LoadingBox($sName)
{
    return $GLOBALS['oFunctions'] -> loadingBox($sName);
}
function PopupBox($sName, $sTitle, $sContent, $aActions = array())
{
    return $GLOBALS['oFunctions'] -> popupBox($sName, $sTitle, $sContent, $aActions);
}
function getTemplateIcon( $sFileName )
{
    return $GLOBALS['oFunctions']->getTemplateIcon($sFileName);
}

function getTemplateImage( $sFileName )
{
    return $GLOBALS['oFunctions']->getTemplateImage($sFileName);
}

function getVersionComment()
{
    global $site;
    $aVer = explode( '.', $site['ver'] );

    // version output made for debug possibilities.
    // randomizing made for security issues. do not change it...
    $aVerR[0] = $aVer[0];
    $aVerR[1] = rand( 0, 100 );
    $aVerR[2] = $aVer[1];
    $aVerR[3] = rand( 0, 100 );
    $aVerR[4] = $site['build'];

    //remove leading zeros
    while( $aVerR[4][0] === '0' )
        $aVerR[4] = substr( $aVerR[4], 1 );

    return '<!-- ' . implode( ' ', $aVerR ) . ' -->';
}

// ----------------------------------- site statistick functions --------------------------------------//

function getSiteStatUser()
{
    global $aStat;
    $aStat = getSiteStatArray();

    $sCode  = '<div class="siteStatMain">';

    foreach($aStat as $aVal)
        $sCode .= $GLOBALS['oFunctions']->getSiteStatBody($aVal);

    $sCode .= '<div class="clear_both"></div></div>';

    return $sCode;
}

function genAjaxyPopupJS($iTargetID, $sDivID = 'ajaxy_popup_result_div', $sRedirect = '')
{
    $iProcessTime = 1000;

    if ($sRedirect)
       $sRedirect = "window.location = '$sRedirect';";

    $sJQueryJS = <<<EOF
<script type="text/javascript">

setTimeout( function(){
    $('#{$sDivID}_{$iTargetID}').show({$iProcessTime})
    setTimeout( function(){
        $('#{$sDivID}_{$iTargetID}').hide({$iProcessTime});
        $sRedirect
    }, 3000);
}, 500);

</script>
EOF;
    return $sJQueryJS;
}

function getBlockWidth ($iAllWidth, $iUnitWidth, $iNumElements)
{
    $iAllowed = $iNumElements * $iUnitWidth;
    if ($iAllowed > $iAllWidth) {
        $iMax = (int)floor($iAllWidth / $iUnitWidth);
        $iAllowed = $iMax*$iUnitWidth;
    }
    return $iAllowed;
}

function getMemberLoginFormCode($sID = 'member_login_form', $sParams = '')
{
    //get all auth types;
    $aAuthTypes = $GLOBALS['MySQL']-> fromCache('sys_objects_auths', 'getAll', 'SELECT * FROM `sys_objects_auths`');

    // define additional auth types;
    if($aAuthTypes) {
        $aAddInputEl[''] = _t('_Basic');

        // procces all additional menu's items
        foreach($aAuthTypes as $iKey => $aItems) {
            $aAddInputEl[$aItems['Link']] = _t($aItems['Title']);
        }

        $aAuthTypes = array(
            'type' => 'select',
            'caption' => _t('_Auth type'),
            'values'    => $aAddInputEl,
            'value' => '',
            'attrs' => array (
                'onchange' => 'if(this.value) {location.href = "' . BX_DOL_URL_ROOT . '" + this.value}',
            ),
        );
    } else {
        $aAuthTypes = array(
            'type' => 'hidden'
        );
    }

    $aForm = array(
        'form_attrs' => array(
            'id' => $sID,
            'action' => BX_DOL_URL_ROOT . 'member.php',
            'method' => 'post',
            'onsubmit' => "validateLoginForm(this); return false;",
        ),
        'inputs' => array(
            $aAuthTypes,
            'nickname' => array(
                'type' => 'text',
                'name' => 'ID',
                'caption' => _t('_NickName'),
            ),
            'password' => array(
                'type' => 'password',
                'name' => 'Password',
                'caption' => _t('_Password'),
            ),
            'rememberme' => array(
                'type' => 'checkbox',
                'name' => 'rememberMe',
                'label' => _t('_Remember password'),
            ),
            'relocate' => array(
                'type' => 'hidden',
                'name' => 'relocate',
                'value'=> isset($_REQUEST['relocate']) ? $_REQUEST['relocate'] : BX_DOL_URL_ROOT . 'member.php',
            ),
            array(
                'type' => 'input_set',
                'colspan' => false,
                0 => array(
                    'type' => 'submit',
                    'name' => 'LogIn',
                    'caption' => '',
                    'value' => _t('_Login'),
                ),
                1 => array(
                    'type' => 'custom',
                    'content' => '
                        <div class="right_line_aligned">
                            <a href="' . BX_DOL_URL_ROOT . 'forgot.php">' . _t("_forgot_your_password") . '?</a>
                        </div>
                        <div class="clear_both"></div>
                    ',
                ),
            ),
        ),
    );

    $oForm = new BxTemplFormView($aForm);

    bx_import('BxDolAlerts');
    $sCustomHtmlBefore = '';
    $sCustomHtmlAfter = '';
    $oAlert = new BxDolAlerts('profile', 'show_login_form', 0, 0, array('oForm' => $oForm, 'sParams' => &$sParams, 'sCustomHtmlBefore' => &$sCustomHtmlBefore, 'sCustomHtmlAfter' => &$sCustomHtmlAfter, 'aAuthTypes' => &$aAuthTypes));
    $oAlert->alert();

    $sFormCode = $oForm->getCode();

    $sJoinText = (strpos($sParams, 'no_join_text') === false) ? '<div class="login_box_text bx-def-margin-sec-top">' . _t('_login_form_description2join', BX_DOL_URL_ROOT) . '</div>' : '';
    return $GLOBALS['oSysTemplate']->parseHtmlByName('default_margin.html', array('content' => $sCustomHtmlBefore . $sFormCode . $sCustomHtmlAfter . $sJoinText));
}

bx_import('BxDolAlerts');
$oZ = new BxDolAlerts('system', 'design_included', 0);
$oZ->alert();
