function doShowHideSecondProfile( sShow, eForm ) {
    if( sShow == 'yes' ) {
        $( '.hidable').show();
        tinyMCE.execCommand('mceRemoveControl', false, 'DescriptionMe[1]');
        tinyMCE.execCommand('mceAddControl', false, 'DescriptionMe[1]');
    } else {
        $( '.hidable').hide();
    }
}

function validateJoinForm( eForm ) {
    if( !eForm )
        return false;
    
    hideJoinFormErrors( eForm );
    
    $(eForm).ajaxSubmit( {
        iframe: false, // force no iframe mode
        beforeSerialize: function() {
            if (window.tinyMCE)
                tinyMCE.triggerSave();
            return true;
        },
        success: function(sResponce) {
            try {
                var aErrors = eval(sResponce);
            } catch(e) {
                return false;
            }
            
            doShowJoinErrors( aErrors, eForm );
        }
    } );
    
    return false;
}

function hideJoinFormErrors( eForm ) {
    $( '.error', eForm ).removeClass( 'error' );
}

function doShowJoinErrors( aErrors, eForm ) {
    if( !aErrors || !eForm )
        return false;
    
    var bHaveErrors = false;
    
    for( var iInd = 0; iInd < aErrors.length; iInd ++ ) {
        var aErrorsInd = aErrors[iInd];
        for( var sField in aErrorsInd ) {
            var sError = aErrorsInd[ sField ];
            bHaveErrors = true;
            
            doShowError( eForm, sField, iInd, sError );
        }
    }
    
    if( bHaveErrors )
        doShowError( eForm, 'do_submit', 0, _t('_Errors in join form') );
    else
        eForm.submit();
}

function doShowError( eForm, sField, iInd, sError ) {
    var $Field = $( "[name='" + sField + "']", eForm ); // single (system) field
    if( !$Field.length ) // couple field
        $Field = $( "[name='" + sField + '[' + iInd + ']' + "']", eForm );
    if( !$Field.length ) // couple multi-select
        $Field = $( "[name='" + sField + '[' + iInd + '][]' + "']", eForm );
    if( !$Field.length ) // couple range (two fields)
        $Field = $( "[name='" + sField + '[' + iInd + '][0]' + "'],[name='" + sField + '[' + iInd + '][1]' + "']", eForm );
    
    //alert( sField + ' ' + $Field.length );
    
    $Field.parents('td:first').addClass( 'error' );
    
    $Field
    .parents('td:first')
        .addClass( 'error' )
        .children( '.warn' )
            .attr('float_info', sError);
}
