<?php
/**
 * Copyright (c) BoonEx Pty Limited - http://www.boonex.com/
 * CC-BY License - http://creativecommons.org/licenses/by/3.0/
 */

require_once(BX_DIRECTORY_PATH_CLASSES . 'BxDolAlerts.php');

class BxWallResponse extends BxDolAlertsResponse
{
    var $_oModule;

    /**
     * Constructor
     * @param BxWallModule $oModule - an instance of current module
     */
    function BxWallResponse($oModule)
    {
        parent::BxDolAlertsResponse();

        $this->_oModule = $oModule;
    }
    /**
     * Overwtire the method of parent class.
     *
     * @param BxDolAlerts $oAlert an instance of alert.
     */
    function response($oAlert)
    {
        $bFromWall = !empty($oAlert->aExtras) && (int)$oAlert->aExtras['from_wall'] == 1;

        if($bFromWall) {
            $this->_oModule->_iOwnerId = (int)$oAlert->aExtras['owner_id'];
            $sMedia = strtolower(str_replace('bx_', '', $oAlert->sUnit));
            $aMediaInfo = $this->_oModule->_oTemplate->getCommonMedia($sMedia, $oAlert->iObject);

            $iOwnerId = $this->_oModule->_iOwnerId;
            $iObjectId = $this->_oModule->_getAuthorId();
            $sType = $this->_oModule->_oConfig->getCommonPostPrefix() . $sMedia;
            $sAction = '';
            $sContent = serialize(array('type' => $sMedia, 'id' => $oAlert->iObject));
            $sTitle = $aMediaInfo['title'];
            $sDescription = $aMediaInfo['description'];
        } else {
            $iOwnerId = $oAlert->iSender;
            $iObjectId = $oAlert->iObject;
            $sType = $oAlert->sUnit;
            $sAction = $oAlert->sAction;
            $sContent = is_array($oAlert->aExtras) && !empty($oAlert->aExtras) ? serialize($oAlert->aExtras) : '';
            $sTitle = $sDescription = '';
        }

        if($oAlert->sUnit == 'profile' && $oAlert->sAction == 'delete') {
            $this->_oModule->_oDb->deleteEvent(array('owner_id' => $oAlert->iObject));
            $this->_oModule->_oDb->deleteEventCommon(array('object_id' => $oAlert->iObject));
            return;
        }

        if($oAlert->sUnit == 'profile' && $oAlert->sAction == 'edit' && $iOwnerId != $iObjectId) {
            return;
        }

        $iId = $this->_oModule->_oDb->insertEvent(array(
            'owner_id' => $iOwnerId,
            'object_id' => $iObjectId,
            'type' => $sType,
            'action' => $sAction,
            'content' => process_db_input($sContent, BX_TAGS_NO_ACTION, BX_SLASHES_NO_ACTION),
            'title' => process_db_input($sTitle, BX_TAGS_NO_ACTION, BX_SLASHES_NO_ACTION),
            'description' => process_db_input($sDescription, BX_TAGS_NO_ACTION, BX_SLASHES_NO_ACTION),
        ));

        if($bFromWall)
            echo "<script>parent." . $this->_oModule->_sJsPostObject . "._getPost(null, " . $iId . ")</script>";
        else
            $this->_oModule->_oDb->updateSimilarObject($iId, $oAlert);
    }
}
